package org.msh.tb.cases.adsm;

import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.faces.FacesMessages;
import org.msh.etbm.commons.transactionlog.mapping.LogInfo;
import org.msh.tb.cases.exams.ExamHome;
import org.msh.tb.entities.AdsmLaboratoryTest;
import org.msh.tb.entities.CaseSideEffect;
import org.msh.tb.entities.enums.YesNoType;

@Name("adsmLaboratoryTestHome")
@LogInfo(roleName="ADV_EFFECTS", entityClass=CaseSideEffect.class)
public class AdsmLaboratoryTestHome extends ExamHome<AdsmLaboratoryTest> {

    @In(create=true)
    FacesMessages facesMessages;

    @Factory("adsmLaboratoryTest")
    public AdsmLaboratoryTest getAdsmLaboratoryTest() {
        return getInstance();
    }


    @Override
    public String persist() {
        if(!validateForm())
            return "error";

        return super.persist();
    }

    public boolean validateForm(){
        AdsmLaboratoryTest test = getInstance();

        if (test.getIndicativeOfAeSae() != null &&
                test.getIndicativeOfAeSae().equals(YesNoType.YES) &&
                test.getIndicativeWhich() == null) {
            facesMessages.addToControlFromResourceBundle("indicativewhich", "javax.faces.component.UIInput.REQUIRED");
            return false;
        }

        return true;
    }

}
